<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>CapturaCodigoBarras</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"><style type="text/css">
<!--
body {
	margin-left: 0px;
	margin-top: 0px;
	margin-right: 0px;
	margin-bottom: 0px;
}
-->
</style></head>
<body>
	<div align="center">
  	<video id="preview" width="280" height="280"></video> <!-- Define el tamao del video -->
  	</div>
  <!--
  <video id="preview"></video>
  -->
  
  <!--
  <input style="font-size:34px; width:100%;" type="text" id="barcodeResult" placeholder="Codigo de barras capturado" >
  
  <script src="https://unpkg.com/quagga/dist/quagga.min.js"></script>
  -->
  <script src="js/quagga.min.js"></script>
  
  <script language="javascript">
	document.addEventListener('DOMContentLoaded', function () {
		const video = document.getElementById('preview');
		//const barcodeResult = document.getElementById('barcodeResult');
		const barcodeResult = parent.document.getElementById('xcodigo_barras');
		
		// Configurar la camara usando getUserMedia
		navigator.mediaDevices.getUserMedia({ video: { facingMode: 'environment' } }) // Solicita la camara trasera
			.then(function (stream) {
				video.srcObject = stream;
				video.play();
	
				// Configurar QuaggaJS
				Quagga.init({
					inputStream: {
						name: "Live",
						type: "LiveStream",
						target: video,
						constraints: {
							width: { min: 280 },
							height: { min: 280 }
						}
					},
					decoder: {
						//readers: ["ean_reader"] // Tipo de codigo de barras que queremos detectar (EAN-13 por ejemplo)
						readers: ["ean_reader", "upc_reader", "code_128_reader"] // Tipos de codigos de barras que deseas detectar
    
					}
				}, function (err) {
					if (err) {
						console.error('Error al inicializar Quagga: ', err);
						return;
					}
					console.log('QuaggaJS inicializado correctamente.');
					Quagga.start();
				});
	
				// Evento cuando se detecta un codigo de barras
				Quagga.onDetected(function (result) {
					barcodeResult.value = result.codeResult.code; // Colocar el codigo de barras en el input text
					
					// Realizar cualquier accion adicional con el codigo de barras capturado
					parent.document.getElementById("btn_cerrar_capturarcodigo").click();
					
					parent.document.getElementById("btn_leer_codigo_barras2").click();
					//parent.leer_codigo_barras2(result.codeResult.code, parent.document.getElementById("zs_emp_codi_fk").value);  
					//console.log('Codigo de barras capturado:', result.codeResult.code);
	
					// No detener Quagga, continuar la deteccion de cdigos
					// Si se desea detener la deteccion despuos de un tiempo, se puede agregar una logica de tiempo o condicion aqui
				});
			})
			.catch(function (error) {
				console.error('Error al acceder a la camara: ', error);
			});
	});

  </script>
  
  
</body>
</html>
